<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wnio="http://piu.mpips.pl/rd/PS_U/1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>PS-U - Ministerstwo Rodziny i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      </head>
      <body style="font-family: Arial; text-align: center; ">
	  
		<!-- Pierwsza część, statyczna formularza + wnioskodawca -->		
		<xsl:call-template name="poczatkowaStatycznaCzescPSU">
		</xsl:call-template>		
		
		<!-- Sekcja statyczna - przed kolejnymi obywatelami Ukrainy -->			  
		<xsl:if test="//wnio:TrescDokumentu/wnio:DaneOsobObywateleUkrainy">
			<xsl:call-template name="statycznaSekcjaObywateleUkrainyPSU">
			</xsl:call-template>
		</xsl:if>

		<!-- Sekcja dynamiczna - kolejni obywatele Ukrainy -->			  	
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:DaneOsobObywateleUkrainy/wnio:DaneObywatelUkrainy">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="dynamicznaSekcjaObywateleUkrainyPSU">
					<xsl:with-param name="BiezacyObywatel" select="position()"/>
				</xsl:call-template>
			</xsl:if>
			
		</xsl:for-each>		
		
		<!-- Ostatnia statyczna część formularza -->
		<xsl:call-template name="ostatniaStatycznaCzescPSU">
		</xsl:call-template>		
		
      </body>
    </html>
  </xsl:template>
  
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates />
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates />
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates />
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="." />
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="dlugoscPolaWPikselach" />
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.6 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.6 * string-length($tekst))" />
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')" />
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 6, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 1, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)" />
      -
      <xsl:value-of select="substring($wartosc, 3, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst" />
    <xsl:param name="wysokosc" />
    <xsl:param name="szerokosc" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="wysokoscLini" />
    <xsl:param name="liczbaPrzejscDoNowychLini" />
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini" />
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)" />
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)" />
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0" />
    <xsl:param name="try" select="1" />
    <xsl:param name="iter" select="1" />
    <xsl:param name="maxiter" select="10" />
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number" />
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))" />
          <xsl:with-param name="iter" select="$iter + 1" />
          <xsl:with-param name="maxiter" select="$maxiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
	  
  <!-- Część implementacyjna formularza -->
  
  <xsl:template name="poczatkowaStatycznaCzescPSU">
	  
		<!-- Początkowa część statyczna formularza -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1220px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">PS-U</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="top: 146px; left: 0px; width: 880px; position: absolute; height: 116px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 116px; " class="SofBorderContainer blueAll">
              <div style="color: #000000; top: 8px; left: 11px; font-weight: bold; width: 859px; font-size: 12px; position: absolute; " class="SofLabel sectionHeader">ORGAN WŁAŚCIWY, DO KTÓREGO JEST SKŁADANY WNIOSEK O WYPŁATĘ JEDNORAZOWEGO ŚWIADCZENIA PIENIĘŻNEGO / ВІДПОВІДНІЙ ОРГАН ДО ЯКОГО ПОДАЄТЬСЯ ЗАЯВКА НА ВИПЛАТУ ОДНОРАЗОВОЇ ГРОШОВОЇ ДОПОМОГИ (1)</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 41px; left: 10px; height: 68px; " class="SofBorderContainer">
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 7px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 54px; " class="SofTextArea dotted">
                  <div style="padding-left:5px ; padding-top:2px; display: block;">
                    <xsl:call-template name="formatTextArea">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                      <xsl:with-param name="wysokosc" select="54" />
                      <xsl:with-param name="szerokosc" select="865" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="wysokoscLini" select="20" />
                      <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                      <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                    </xsl:call-template>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div style="top: 261px; left: 0px; width: 880px; position: absolute; height: 293px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">ADRES ORGANU WŁAŚCIWEGO / АДРЕСА ВІДПОВІДНОГО ОРГАНУ</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 260px; " class="SofBorderContainer">
                <div style="width: 145px; font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">
                  02. Kod pocztowy /
                  <br />
                  Поштовий індекс
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 76px; left: 3px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 63px; left: 171px; " class="SofLabel">03. Miejscowość / Населений пункт</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 76px; left: 171px; display: block; width: 697px; font-size: 18px; position: absolute; height: 27px; text-align: left; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:27px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Miejscowosc" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Gmina / Район</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 107px; left: 3px; " class="SofLabel">04. Ulica / Вулиця</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 120px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 151px; left: 3px; " class="SofLabel">05. Numer domu / Номер будиноку</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 164px; left: 3px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 151px; left: 235px; " class="SofLabel">06. Numer mieszkania / Номер квартири</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 164px; left: 235px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="color: #000000; top: 197px; left: 3px; width: 857px; font-size: 12px; position: absolute; height: 60px; " class="SofLabel">(1) Świadczenie wypłaca ośrodek pomocy społecznej, a w przypadku przekształcenia ośrodka pomocy społecznej w centrum usług społecznych – centrum usług społecznych, lub inna jednostka organizacyjna gminy właściwej ze względu na miejsce pobytu obywatela Ukrainy. / Допомога виплачується центром соціального захисту населення, а у разі перетворення центру соціального захисту населення у центр соціальних служб - центром соціальних служб або іншим організаційним центром муніципальної власності, віднесеним до компетенції за місцем проживання громадянина України.</div>
              </div>
            </div>
          </div>
          <div style="color: #000000; top: 566px; left: 6px; font-weight: bold; width: 100%; font-size: 14px; font-family: arial; position: absolute; height: 48px; text-align: center; " class="SofLabel global14Bold">DANE OSÓB SKŁADAJĄCYCH WNIOSEK LUB DANE OSÓB UPRAWNIONYCH/ ДАНІ ОСІБ ЩО ПОДАЮТЬ ЗАЯВКУ АБО ДАНІ УПОВНОВАЖЕНИХ ОСІБ</div>
          <div style="color: #000000; top: 616px; left: 11px; font-weight: bold; width: 859px; font-size: 14px; position: absolute; text-align: justify; height: 102px; " class="SofLabel justified14Bold">
            1. Dane obywatela Ukrainy, którego pobyt na terytorium Rzeczypospolitej Polskiej jest uznawany za legalny na podstawie
            <br />
            art. 2 ust. 1 ustawy z dnia 12 marca 2022 r. o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa, składającego wniosek, lub dane osoby składającej wniosek w imieniu osoby uprawnionej / Дані громадянина України, перебування якого на території Республіки Польща вважається законним відповідно до ст. 2 пункт 1 Закону від 12 березня 2022 року про допомогу громадянам України у зв'язку зі збройним конфліктом на території цієї держави, які подають заяву, або дані особи, яка подає заяву від імені уповноваженої особи (**)
          </div>
          <div style="top: 727px; left: 0px; width: 880px; position: absolute; height: 405px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE OSOBY / ДАНІ ОСОБИ (1)</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 370px; " class="SofBorderContainer">
                <div style="width: 265px; font-size: 12px; position: absolute; color: #000000; top: 109px; left: 3px; " class="SofLabel">04. Numer PESEL / Номер ПЕСЕЛЬ</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 122px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:PESEL" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">
                  05. Data urodzenia (dd / mm / rrrr) /
                  <br />
                  Дата народження (день / місяць / рік)
                </div>
                <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 122px; left: 291px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:DataUrodzenia" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
                <div style="color: #000000; top: 93px; left: 559px; width: 300px; font-size: 12px; position: absolute; height: 30px; " class="SofLabel">
                  06. Płeć / Стать (wpisz odpowiednio / виберіть:
                  <br />
                  K - kobieta / жінка, M - mężczyzna / чоловік)
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 122px; left: 559px; display: block; width: 48px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofDropDownList">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Plec" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="48" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 321px; left: 4px; " class="SofLabel">(1) W przypadku gdy wnioskodawca nie jest osobą uprawnioną do jednorazowego świadczenia pieniężnego i składa wniosek w imieniu osoby uprawnionej – wypełnia się pole: 01–05 i 08 / Якщо заявник не є особою, яка має право на одноразову грошову допомогу, і подає заяву від імені особи, яка має право, - заповнюються поля 01–05 та 08.</div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 169px; left: 4px; " class="SofLabel">
                  07. Rodzaj dokumentu stanowiącego podstawę przekroczenia granicy /
                  <br />
                  Тип документу, що є підставою для перетину кордону
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 198px; left: 4px; display: block; width: 528px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:RodzajDokumentu" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="528" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 154px; left: 559px; " class="SofLabel">
                  08. Seria i numer dokumentu stanowiącego podstawę
                  <br />
                  przekroczenia granicy / Cерія та номер документу,
                  <br />
                  що є підставою для перетину кордону
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 198px; left: 559px; display: block; width: 289px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:SeriaNumerDokumentu" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="289" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 186px; font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">03. Nazwisko / Прізвище</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Nazwisko" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 110px; font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię / Ім’я</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 420px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Imie" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="420" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 210px; font-size: 12px; position: absolute; color: #000000; top: 5px; left: 448px; " class="SofLabel">02. Drugie imię / Друге ім'я</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 448px; display: block; width: 420px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:ImieDrugie" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="420" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 229px; left: 3px; " class="SofLabel">09. Obywatelstwo / Громадянство</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 242px; left: 3px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Obywatelstwo" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 273px; left: 3px; " class="SofLabel">10. Data wjazdu na terytorium Rzeczypospolitej Polskiej (dd / mm / rrrr) / Дата в'їзду на територію Республіки Польща (день / місяць / рік)</div>
                <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 285px; left: 3px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:DataWjazduDoRP" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
              </div>
            </div>
          </div>
          <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 1141px; left: 14px; " class="SofLabel">(*) Jednorazowe świadczenie pieniężne, o którym mowa w art. 31 ustawy z dnia 12 marca 2022 r. o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa (Dz. U. poz. 583) / Одноразова грошова допомога, передбачена ст. 31 Закону від 12 березня 2022 року про допомогу громадянам України у зв'язку зі збройним конфліктом на території цієї держави (Вісник законів, ст. 583).</div>
          <div style="color: #000000; top: 1188px; left: 14px; width: 856px; font-size: 12px; position: absolute; height: 32px; " class="SofLabel">(**) Wniosek składa osoba uprawniona, jej przedstawiciel ustawowy, opiekun tymczasowy albo osoba sprawująca faktyczną pieczę nad dzieckiem / Заява подається уповноваженою особою, її законним представником, тимчасовим опікуном або особою, яка фактично опікується дитиною.</div>
          <div style="color: #000000; top: 40px; left: 0px; font-weight: bold; width: 100%; font-size: 16px; position: absolute; text-align: center; height: 90px; " class="SofLabel formTitle">
            WNIOSEK
            <br />
            O WYPŁATĘ JEDNORAZOWEGO ŚWIADCZENIA PIENIĘŻNEGO /
            <br />
            ЗАЯВКА
            <br />
            НА ВИПЛАТУ ОДНОРАЗОВОЇ ФІНАНСОВОЇ ДОПОМОГИ (*)
          </div>
        </div>
		
		<!-- Strona druga: statyczna -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 740px; margin-right: auto; text-align: left; ">
          <div style="top: 25px; left: 0px; width: 880px; position: absolute; height: 295px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">ADRES POBYTU / АДРЕСА ПЕРЕБУВАННЯ</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 260px; " class="SofBorderContainer">
                <div style="width: 145px; font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">
                  02. Kod pocztowy /
                  <br />
                  Поштовий індекс
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 76px; left: 3px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="width: 269px; font-size: 12px; position: absolute; color: #000000; top: 63px; left: 171px; " class="SofLabel">03. Miejscowość / Населений пункт</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 76px; left: 171px; display: block; width: 697px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:Miejscowosc" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 327px; font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Gmina / Район</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 327px; font-size: 12px; position: absolute; color: #000000; top: 107px; left: 3px; " class="SofLabel">04. Ulica / Вулиця</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 120px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 208px; font-size: 12px; position: absolute; color: #000000; top: 151px; left: 3px; " class="SofLabel">05. Numer domu / Номер будиноку</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 164px; left: 3px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="width: 261px; font-size: 12px; position: absolute; color: #000000; top: 151px; left: 235px; " class="SofLabel">06. Numer mieszkania / Номер квартири</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 164px; left: 235px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="width: 241px; font-size: 12px; position: absolute; color: #000000; top: 151px; left: 511px; " class="SofLabel">07. Numer telefonu / Номер телефону</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 164px; left: 511px; display: block; width: 241px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:NumerTelefonu" />
                  </span>
                </div>
                <div style="width: 509px; font-size: 12px; position: absolute; color: #000000; top: 195px; left: 3px; " class="SofLabel">08. Adres poczty elektronicznej — e-mail / Адрес електронної пошти (1)</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 208px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresPobytu/wnio:AdresPocztyElektronicznej" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 790px; font-size: 12px; position: absolute; color: #000000; top: 241px; left: 4px; " class="SofLabel">(1) O ile posiada / Якщо володіє.</div>
              </div>
            </div>
          </div>

          <div style="color: #000000; top: 331px; left: 11px; font-weight: bold; width: 859px; font-size: 14px; position: absolute; text-align: justify; height: 50px; " class="SofLabel justified14Bold">
            NUMER RACHUNKU BANKOWEGO, NA KTÓRY ZOSTANIE PRZEKAZANA KWOTA JEDNORAZOWEGO ŚWIADCZENIA PIENIĘŻNEGO / НОМЕР БАНКІВСЬКОГО РАХУНКУ, НА ЯКИЙ БУДЕ ПЕРЕСИЛАТИСЯ СУМА ОДНОРАЗОВОЇ ГРОШОВОЇ
            <br />
            ДОПОМОГИ (***)
          </div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 385px; left: 13px; " class="SofLabel">01. Imię i nazwisko właściciela rachunku / Ім’я та прізвище власника рахунку</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 398px; left: 13px; display: block; width: 866px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:ImieNazwiskoWlasciciela" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="866" />
              </xsl:call-template>
            </span>
          </div>
          <div style="width: 857px; font-size: 12px; position: absolute; color: #000000; top: 435px; left: 13px; " class="SofLabel">02. Numer rachunku bankowego w Polsce / Номер банківського рахунку в Польщі (1)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 450px; left: 13px; display: block; width: 625px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:RachunekPolska/wnio:NrRachunkuPolska" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="625" />
              </xsl:call-template>
            </span>
          </div>
          <div style="width: 857px; font-size: 12px; position: absolute; color: #000000; top: 485px; left: 13px; " class="SofLabel">03. Numer zagranicznego rachunku bankowego / Номер рахунку в іноземному банку (1)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 500px; left: 13px; display: block; width: 866px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:RachunekZagranica/wnio:NrRachunkuZagranica" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="866" />
              </xsl:call-template>
            </span>
          </div>
          <div style="width: 857px; font-size: 12px; position: absolute; color: #000000; top: 535px; left: 13px; " class="SofLabel">04. Międzynarodowy identyfikator banku w formacie BIC/SWIFT / Міжнародний банківський ідентифікатор у форматі BIC/SWIFT</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 550px; left: 13px; display: block; width: 264px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:RachunekZagranica/wnio:IdentyfikatorBanku" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="264" />
              </xsl:call-template>
            </span>
          </div>
          <div style="width: 857px; font-size: 12px; position: absolute; color: #000000; top: 585px; left: 13px; " class="SofLabel">05. Nazwa i adres banku / Назва та адреса банку</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 600px; left: 13px; display: block; width: 866px; font-size: 18px; position: absolute; height: 81px; " class="SofTextArea dotted">
            <div style="padding-left:5px ; padding-top:2px; display: block;">
              <xsl:call-template name="formatTextArea">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:RachunekZagranica/wnio:NazwaAdresBanku" />
                <xsl:with-param name="wysokosc" select="81" />
                <xsl:with-param name="szerokosc" select="865" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="wysokoscLini" select="20" />
                <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:RachunekZagranica/wnio:NazwaAdresBanku" />
              </xsl:call-template>
            </div>
          </div>
          <div style="color: #000000; top: 685px; left: 13px; width: 857px; font-size: 12px; position: absolute; height: 16px; " class="SofLabel left">(1) Podaj numer rachunku w standardzie IBAN / Введіть номер рахунку в стандарті IBAN.</div>
          <div style="color: #000000; top: 707px; left: 13px; width: 857px; font-size: 12px; position: absolute; height: 30px; " class="SofLabel left">(***) Należy wypełnić w przypadku możliwości otrzymania świadczenia w formie przelewu na rachunek bankowy / Заповнюється, якщо є можливість отримати пільгу у вигляді переказу на банківський рахунок.</div>
        </div>

  </xsl:template>		

  <xsl:template name="statycznaSekcjaObywateleUkrainyPSU">
		
		<!-- Strona druga-uzupełnienie: statyczna -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 140px; margin-right: auto; text-align: left; ">
          <div style="color: #000000; top: 12px; left: 11px; font-weight: bold; width: 859px; font-size: 14px; position: absolute; text-align: justify; height: 120px; " class="SofLabel justified14Bold">2. Dane osób, będących obywatelami Ukrainy, których pobyt na terytorium Rzeczypospolitej Polskiej jest uznawany za legalny na podstawie art. 2 ust. 1 ustawy z dnia 12 marca 2022 r. o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa – &#xa0;&#xa0;w imieniu których wniosek składa przedstawiciel ustawowy, opiekun tymczasowy albo osoba sprawująca faktyczną pieczę nad dzieckiem / Дані осіб, які є громадянами України, перебування яких на території Республіки Польща вважається законним на підставі ст. 2 пункт 1 Закону від 12 березня 2022 року про допомогу громадянам України у зв’язку зі збройним конфліктом на території цієї держави, від імені яких подає заяву законний представник, тимчасовий опікун або особа, яка фактично виконує опіку над дитиною.</div>
        </div>
		
  </xsl:template>		
	
  <xsl:template name="dynamicznaSekcjaObywateleUkrainyPSU">
		<xsl:param name="BiezacyObywatel"/>

		<!-- Strona dynamiczna formularza (Obywatele Ukrainy) -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 645px; margin-right: auto; text-align: left; ">

          <div style="top: 25px; left: 0px; width: 880px; position: absolute; height: 355px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE OSOBY / ДАНІ ОСОБИ - <xsl:value-of select="$BiezacyObywatel"/></div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 320px; " class="SofBorderContainer">
                <div style="width: 265px; font-size: 12px; position: absolute; color: #000000; top: 109px; left: 3px; " class="SofLabel">04. Numer PESEL / Номер ПЕСЕЛЬ</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 122px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="wnio:DaneIdentyfikacyjne/wnio:PESEL" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">
                  05. Data urodzenia (dd / mm / rrrr) /
                  <br />
                  Дата народження (день / місяць / рік)
                </div>
                <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 122px; left: 291px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="wnio:DaneIdentyfikacyjne/wnio:DataUrodzenia" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
                <div style="color: #000000; top: 93px; left: 559px; width: 300px; font-size: 12px; position: absolute; height: 30px; " class="SofLabel">
                  06. Płeć / Стать (wpisz odpowiednio / виберіть:
                  <br />
                  K - kobieta / жінка, M - mężczyzna / чоловік)
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 122px; left: 559px; display: block; width: 48px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofDropDownList">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjne/wnio:Plec" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="48" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="color: #000000; top: 169px; left: 4px; width: 528px; font-size: 12px; position: absolute; height: 30px; " class="SofLabel">
                  07. Rodzaj dokumentu stanowiącego podstawę przekroczenia granicy /
                  <br />
                  Тип документу, що є підставою для перетину кордону
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 198px; left: 4px; display: block; width: 528px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjne/wnio:RodzajDokumentu" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="528" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 154px; left: 559px; " class="SofLabel">
                  08. Seria i numer dokumentu stanowiącego podstawę
                  <br />
                  przekroczenia granicy / Cерія та номер &#xa0;документу,
                  <br />
                  що є підставою для перетину кордону
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 198px; left: 559px; display: block; width: 289px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="wnio:DaneIdentyfikacyjne/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="width: 186px; font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">03. Nazwisko / Прізвище</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjne/wnio:Nazwisko" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 110px; font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię / Ім’я</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 420px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjne/wnio:Imie" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="420" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 210px; font-size: 12px; position: absolute; color: #000000; top: 5px; left: 448px; " class="SofLabel">02. Drugie imię / Друге ім'я</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 448px; display: block; width: 420px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjne/wnio:ImieDrugie" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="420" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 229px; left: 3px; " class="SofLabel">09. Obywatelstwo / Громадянство</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 242px; left: 3px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjne/wnio:Obywatelstwo" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 273px; left: 3px; " class="SofLabel">10. Data wjazdu na terytorium Rzeczypospolitej Polskiej (dd / mm / rrrr) / Дата в'їзду на територію Республіки Польща (день / місяць / рік)</div>
                <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 285px; left: 3px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="wnio:DaneIdentyfikacyjne/wnio:DataWjazduDoRP" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
              </div>
            </div>
          </div>

          <div style="top: 382px; left: 0px; width: 880px; position: absolute; height: 235px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">ADRES POBYTU / АДРЕСА ПЕРЕБУВАННЯ - <xsl:value-of select="$BiezacyObywatel"/></div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 200px; " class="SofBorderContainer">
                <div style="width: 145px; font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">
                  02. Kod pocztowy /
                  <br />
                  Поштовий індекс
                </div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 76px; left: 3px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="wnio:AdresPobytu/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(wnio:AdresPobytu/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(wnio:AdresPobytu/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="width: 269px; font-size: 12px; position: absolute; color: #000000; top: 63px; left: 171px; " class="SofLabel">03. Miejscowość / Населений пункт</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 76px; left: 171px; display: block; width: 697px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:AdresPobytu/wnio:Miejscowosc" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 327px; font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Gmina / Район</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:AdresPobytu/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 327px; font-size: 12px; position: absolute; color: #000000; top: 107px; left: 3px; " class="SofLabel">04. Ulica / Вулиця</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 120px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="wnio:AdresPobytu/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 224px; font-size: 12px; position: absolute; color: #000000; top: 151px; left: 3px; " class="SofLabel">05. Numer domu / Номер будиноку</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 164px; left: 3px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="wnio:AdresPobytu/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="width: 261px; font-size: 12px; position: absolute; color: #000000; top: 151px; left: 235px; " class="SofLabel">06. Numer mieszkania / Номер квартири</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 164px; left: 235px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="wnio:AdresPobytu/wnio:NumerLokalu" />
                  </span>
                </div>
              </div>
            </div>
          </div>		  

        </div>

  </xsl:template>		
    
  <xsl:template name="ostatniaStatycznaCzescPSU">
		<!-- Końcowa część statyczna formularza (oświadczenia) -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 410px; margin-right: auto; text-align: left; ">
          <div style="color: #000000; top: 33px; left: 11px; font-weight: bold; width: 859px; font-size: 14px; position: absolute; text-align: center; height: 30px; " class="SofLabel justified14Bold">OŚWIADCZENIA / ЗАЯВИ</div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 61px; left: 0px; height: 215px; " class="SofBorderContainer">
            <div style="color: #000000; top: 11px; left: 6px; font-weight: normal; width: 805px; font-size: 14px; font-family: arial; position: absolute; height: 22px; " class="SofLabel global14Normal">Oświadczam, że: / Я заявляю, що:</div>
            <div style="color: #000000; top: 31px; left: 26px; font-weight: normal; width: 805px; font-size: 14px; font-family: arial; position: absolute; height: 22px; " class="SofLabel global14Normal">1) jestem / я є: &#xa0;&#xa0;&#xa0;</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 51px; left: 44px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox justified11">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:OswiadczenieTrescPkt1/wnio:PrzedstawicielUstawowy='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="color: #000000; top: 51px; left: 78px; font-weight: normal; width: 795px; font-size: 14px; font-family: arial; position: absolute; height: 39px; " class="SofLabel global14Normal">przedstawicielem ustawowym osoby uprawnionej do świadczenia / законним представником особи, яка має право на допомогу,</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 87px; left: 44px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox justified11">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:OswiadczenieTrescPkt1/wnio:OpiekunTymczasowy='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="color: #000000; top: 95px; left: 78px; font-weight: normal; width: 795px; font-size: 14px; font-family: arial; position: absolute; height: 20px; " class="SofLabel global14Normal">opiekunem tymczasowym osoby uprawnionej do świadczenia / тимчасовим опікуном особи, яка має право на допомогу,</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 123px; left: 44px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox justified11">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:OswiadczenieTrescPkt1/wnio:OsobaSprawujacaPiecze='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="color: #000000; top: 123px; left: 78px; font-weight: normal; width: 795px; font-size: 14px; font-family: arial; position: absolute; height: 34px; " class="SofLabel global14Normal">osobą sprawującą faktyczną pieczę nad dzieckiem uprawnionym do świadczenia / особою, яка фактично здійснює опіку над дитиною, яка має право на допомогу;</div>
            <div style="color: #000000; top: 176px; left: 26px; font-weight: normal; width: 27px; font-size: 14px; font-family: arial; position: absolute; height: 22px; " class="SofLabel global14Normal">2)</div>
            <div style="color: #000000; top: 176px; left: 78px; font-weight: normal; width: 795px; font-size: 14px; font-family: arial; position: absolute; height: 22px; " class="SofLabel global14Normal">wszystkie podane we wniosku dane są zgodne z prawdą / всі дані, надані в заявці, відповідають дійсності.</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 169px; left: 44px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox justified11">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:OswiadczenieTrescPkt2/wnio:PotwierdzenieDaneZgodne='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
          </div>
          <div style="top: 303px; left: 5px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 0px; width: 460px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Miejscowość / Населений пункт)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 35px; text-align: center; " class="SofLabel">
                (Data: dd/mm/rrrr /
                <br />
                Дата: день/місяць/рік)
              </div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 35px; text-align: center; " class="SofLabel">
                (Podpis Wnioskodawcy /
                <br />
                Підпис Заявника)
              </div>
            </div>
          </div>
        </div>
  </xsl:template>		
  
</xsl:stylesheet>
