<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" 
xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd" 
xmlns:mkd="http://mpips.gov.pl/xsd/csizs/pi/mkm/dok/ogolne/v2">
	<xsl:template match="/">
		<html>
			<head>
				<title>Pismo ogólne (Formularz) - Ministerstwo Pracy i Polityki Społecznej</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			</head>
			<body style="text-align: center; font-family: Arial; ">
				<div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
					<div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
						<div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">Pismo ogólne</div>
						<div style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page">MINISTERSTWO &#xa0;PRACY &#xa0;I &#xa0;POLITYKI &#xa0;SPOŁECZNEJ</div>
						<div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 25px; " class="SofHRule">
							<span/>
						</div>
					</div>
					<!-- NADAWCA -->
					<div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 150px; " class="SofLabel global14Bold">NADAWCA</div>
					<div style="position: absolute; height: 101px; width: 880px; left: 0px; top: 165px; ">
						<div style="position: absolute; height: 101px; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
							<div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">NAZWA NADAWCY</div>
							<div style="position: absolute; height: 68px; width: 869px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
								<div style="position: absolute; line-height: 20px; height: 54px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 7px; " class="SofTextArea dotted">
									<div style="padding-left:5px ; padding-top:2px; display: block;">
										<xsl:call-template name="formatTextArea">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:Nadawca"/>
											<xsl:with-param name="wysokosc" select="54"/>
											<xsl:with-param name="szerokosc" select="865"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="wysokoscLini" select="20"/>
											<xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"/>
											<xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//mkd:TrescDokumentu/mkd:Nadawca"/>
										</xsl:call-template>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- ADRES NADAWCY -->
					<div style="position: absolute; height: 265px; width: 880px; left: 0px; top: 260px; ">
						<div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
							<div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES NADAWCY</div>
							<div style="position: absolute; height: 227px; width: 869px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:KodPocztowy"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 673px; font-size: 18px; background-color: white; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
									<span style="padding-left:5px ;line-height:25pxdisplay: block;">
										<xsl:call-template name="redukcjaCzcionki">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:Miejscowosc"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="dlugoscPolaWPikselach" select="673"/>
										</xsl:call-template>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
									<span style="padding-left:5px ;line-height:25pxdisplay: block;">
										<xsl:call-template name="redukcjaCzcionki">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:GminaDzielnica"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
										</xsl:call-template>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
									<span style="padding-left:5px ;line-height:25pxdisplay: block;">
										<xsl:call-template name="redukcjaCzcionki">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:Ulica"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
										</xsl:call-template>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:NumerDomu"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer lokalu</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:NumerLokalu"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; width: 160px; font-size: 12px; left: 411px; top: 137px; " class="SofLabel">07. Symbol państwa</div>
								<div style="position: absolute; height: 27px; color: #000000; overflow: hidden; width: 72px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 411px; border: 1px solid black; top: 150px; " class="SofDropDownList dictionary">
									<span style="padding-left: 5px; line-height:27px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:SymbolPanstwa"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; width: 189px; font-size: 12px; left: 3px; top: 181px; " class="SofLabel">08. Zagraniczny kod pocztowy</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 289px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:ZagranicznyKodPocztowy"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 315px; top: 181px; " class="SofLabel">09. Nazwa państwa</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 547px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 315px; border: 1px solid black; top: 194px; " class="SofComboBox dotted">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresNadawcy/mkd:NazwaPanstwa"/>
									</span>
								</div>
							</div>
						</div>
					</div>
					<!-- ODBIORCA -->
					<div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 550px; " class="SofLabel global14Bold">ODBIORCA</div>
					<div style="position: absolute; height: 101px; width: 880px; left: 0px; top: 565px; ">
						<div style="position: absolute; height: 101px; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
							<div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">NAZWA ODBIORCY</div>
							<div style="position: absolute; height: 68px; width: 869px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
								<div style="position: absolute; line-height: 20px; height: 54px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 7px; " class="SofTextArea dotted">
									<div style="padding-left:5px ; padding-top:2px; display: block;">
										<xsl:call-template name="formatTextArea">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:Odbiorca"/>
											<xsl:with-param name="wysokosc" select="54"/>
											<xsl:with-param name="szerokosc" select="865"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="wysokoscLini" select="20"/>
											<xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"/>
											<xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//mkd:TrescDokumentu/mkd:Odbiorca"/>
										</xsl:call-template>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- ADRES ODBIORCY -->
					<div style="position: absolute; height: 265px; width: 880px; left: 0px; top: 666px; ">
						<div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
							<div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES ODBIORCY</div>
							<div style="position: absolute; height: 227px; width: 869px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:KodPocztowy"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 673px; font-size: 18px; background-color: white; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
									<span style="padding-left:5px ;line-height:25pxdisplay: block;">
										<xsl:call-template name="redukcjaCzcionki">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:Miejscowosc"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="dlugoscPolaWPikselach" select="673"/>
										</xsl:call-template>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
									<span style="padding-left:5px ;line-height:25pxdisplay: block;">
										<xsl:call-template name="redukcjaCzcionki">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:GminaDzielnica"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
										</xsl:call-template>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
									<span style="padding-left:5px ;line-height:25pxdisplay: block;">
										<xsl:call-template name="redukcjaCzcionki">
											<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:Ulica"/>
											<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
											<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
										</xsl:call-template>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:NumerDomu"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer lokalu</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:NumerLokalu"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; width: 160px; font-size: 12px; left: 411px; top: 137px; " class="SofLabel">07. Symbol państwa</div>
								<div style="position: absolute; height: 27px; color: #000000; overflow: hidden; width: 72px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 411px; border: 1px solid black; top: 150px; " class="SofDropDownList dictionary">
									<span style="padding-left: 5px; line-height:27px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:SymbolPanstwa"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; width: 189px; font-size: 12px; left: 3px; top: 181px; " class="SofLabel">08. Zagraniczny kod pocztowy</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 289px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofTextInput">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:ZagranicznyKodPocztowy"/>
									</span>
								</div>
								<div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 315px; top: 181px; " class="SofLabel">09. Nazwa państwa</div>
								<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 547px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 315px; border: 1px solid black; top: 194px; " class="SofComboBox dotted">
									<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
										<xsl:value-of select="//mkd:TrescDokumentu/mkd:AdresOdbiorcy/mkd:NazwaPanstwa"/>
									</span>
								</div>
							</div>
						</div>
					</div>
					<!-- STOPKA -->
					<div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
						<div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: Pismo ogólne(1)</div>
						<div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 1/2</div>
						<div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 1px; " class="SofHRule">
							<span/>
						</div>
					</div>
					<div style="position: absolute; height: 80px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 80px; " class="SofLabel formTitle">
            KORESPONDENCJA
					</div>
				</div>
				<!-- DRUGA STRONA -->
				<div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
					<div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
						<div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">Pismo ogólne</div>
						<div style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page">MINISTERSTWO &#xa0;PRACY &#xa0;I &#xa0;POLITYKI &#xa0;SPOŁECZNEJ</div>
						<div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 25px; " class="SofHRule">
							<span/>
						</div>
					</div>
					<!-- NrDokumentu-->
					<div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 50px; " class="SofLabel global14Bold">NR DOKUMENTU:</div>					
					<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 6px; border: 1px solid black; top: 66px; " class="SofTextInput dotted">
						<span style="padding-left:5px ;line-height:25px; display: block;">
							<xsl:call-template name="redukcjaCzcionki">
								<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:NumerDokumentu"/>
								<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
								<xsl:with-param name="dlugoscPolaWPikselach" select="865"/>
							</xsl:call-template>
						</span>
					</div>
					<!-- TytulDokumentu-->
					<div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 106px; " class="SofLabel global14Bold">TYTUŁ DOKUMENTU:</div>									
					<div style="position: absolute; height: 68px; width: 865px; background-color: #ffffff; left: 6px; top: 122px; " class="SofBorderContainer">
						<div style="position: absolute; line-height: 20px; height: 54px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 1px; " class="SofTextArea dotted">
							<div style="padding-left:5px ; padding-top:2px; display: block;">
								<xsl:call-template name="formatTextArea">
									<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:TytulDokumentu"/>
									<xsl:with-param name="wysokosc" select="54"/>
									<xsl:with-param name="szerokosc" select="865"/>
									<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
									<xsl:with-param name="wysokoscLini" select="20"/>
									<xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"/>
									<xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//mkd:TrescDokumentu/mkd:TytulDokumentu"/>
								</xsl:call-template>
							</div>
						</div>
					</div>
					<!-- TrescKorespondencji-->
					<div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 195px; " class="SofLabel global14Bold">TREŚĆ KORESPONDENCJI:</div>
					<div style="position: absolute; line-height: 20px; height: 741px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 8px; border: 1px solid black; top: 211px; " class="SofTextArea dotted">
						<div style="padding-left:5px ; padding-top:2px; display: block;">
							<xsl:call-template name="formatTextArea">
								<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:TrescKorespondencji"/>
								<xsl:with-param name="wysokosc" select="741"/>
								<xsl:with-param name="szerokosc" select="865"/>
								<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
								<xsl:with-param name="wysokoscLini" select="20"/>
								<xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"/>
								<xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//mkd:TrescDokumentu/mkd:TrescKorespondencji"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Zalaczniki-->
					<div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 972px; " class="SofLabel global14Normal">Załączniki:</div>
					<div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 999px; " class="SofLabel global14Normal">1)</div>
					<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 992px; " class="SofTextInput dotted">
						<span style="padding-left:5px ;line-height:25pxdisplay: block;">
							<xsl:call-template name="redukcjaCzcionki">
								<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:ZalaczoneDokumenty/mkd:Zalacznik1"/>
								<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
								<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
							</xsl:call-template>
						</span>
					</div>
					<div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 1030px; " class="SofLabel global14Normal">2)</div>
					<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 1023px; " class="SofTextInput dotted">
						<span style="padding-left:5px ;line-height:25pxdisplay: block;">
							<xsl:call-template name="redukcjaCzcionki">
								<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:ZalaczoneDokumenty/mkd:Zalacznik2"/>
								<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
								<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
							</xsl:call-template>
						</span>
					</div>
					<div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 1061px; " class="SofLabel global14Normal">3)</div>
					<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 1054px; " class="SofTextInput dotted">
						<span style="padding-left:5px ;line-height:25pxdisplay: block;">
							<xsl:call-template name="redukcjaCzcionki">
								<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:ZalaczoneDokumenty/mkd:Zalacznik3"/>
								<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
								<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
							</xsl:call-template>
						</span>
					</div>
					<div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 1092px; " class="SofLabel global14Normal">4)</div>
					<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 1085px; " class="SofTextInput dotted">
						<span style="padding-left:5px ;line-height:25pxdisplay: block;">
							<xsl:call-template name="redukcjaCzcionki">
								<xsl:with-param name="tekst" select="//mkd:TrescDokumentu/mkd:ZalaczoneDokumenty/mkd:Zalacznik4"/>
								<xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
								<xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
							</xsl:call-template>
						</span>
					</div>
					<div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 1148px; ">
						<div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
							<div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
							<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
								<span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
									<xsl:value-of select="//mkd:TrescDokumentu/mkd:Miejscowosc"/>
								</span>
							</div>
							<div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
								<span style="padding-left:5px ; line-height:25px; display: block;">
									<xsl:call-template name="formatDaty">
										<xsl:with-param name="wartosc" select="//mkd:TrescDokumentu/mkd:Data"/>
									</xsl:call-template>
								</span>
								<span/>
							</div>
							<div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
							<div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal">......................................</div>
							<div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel">Podpis</div>
						</div>
					</div>
					<!--STOPKA-->
					<div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
						<div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: Pismo ogólne(1)</div>
						<div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 2/2</div>
						<div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 1px; " class="SofHRule">
							<span/>
						</div>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="Info">
		<xsl:choose>
			<xsl:when test="name(.) = 'TextFlow'">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:when test="name(.) = 'br'">
				<xsl:choose>
					<xsl:when test="name(..) = 'dl'">
						<xsl:apply-templates/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="{name(.)}">
							<xsl:apply-templates/>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="{name(.)}">
					<xsl:for-each select="@*">
						<xsl:attribute name="{name(.)}"><xsl:value-of select="."/></xsl:attribute>
					</xsl:for-each>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="redukcjaCzcionki">
		<xsl:param name="tekst"/>
		<xsl:param name="bazowyRozmiarCzcionki"/>
		<xsl:param name="dlugoscPolaWPikselach"/>
		<xsl:variable name="dlugoscTekstuWPikselach">
			<!-- chodzi o makstylana dlugosc - przypadek kiedy caly tekst skladal sie z liter 'W' -->
			<xsl:value-of select="string-length($tekst) * $bazowyRozmiarCzcionki"/>
		</xsl:variable>
		<xsl:variable name="roznicaDlugosciTekstuIPolaWPikselach">
			<xsl:value-of select="$dlugoscTekstuWPikselach - $dlugoscPolaWPikselach"/>
		</xsl:variable>
		<xsl:variable name="docelowyRozmiarCzcionki">
			<xsl:choose>
				<xsl:when test="$roznicaDlugosciTekstuIPolaWPikselach &lt; 0">1</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="ulamekOJakiZmniejszamyCzcionke">
						<xsl:value-of select="($roznicaDlugosciTekstuIPolaWPikselach div $dlugoscTekstuWPikselach)"/>
					</xsl:variable>
					<xsl:value-of select="1 - $ulamekOJakiZmniejszamyCzcionke"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<span>
			<xsl:attribute name="style"><xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'em')"/></xsl:attribute>
			<xsl:value-of select="$tekst"/>
		</span>
	</xsl:template>
	<xsl:template name="formatDaty">
		<xsl:param name="wartosc"/>
		<xsl:if test="$wartosc != ''">
			<xsl:value-of select="substring($wartosc, 9, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="formatKoduPocztowego">
		<xsl:param name="wartosc"/>
		<xsl:if test="$wartosc != ''">
			<xsl:value-of select="substring($wartosc, 1, 2)"/>
      -
      <xsl:value-of select="substring($wartosc, 3, 4)"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="formatTextArea">
		<xsl:param name="tekst"/>
		<xsl:param name="wysokosc"/>
		<xsl:param name="szerokosc"/>
		<xsl:param name="bazowyRozmiarCzcionki"/>
		<xsl:param name="wysokoscLini"/>
		<xsl:param name="liczbaPrzejscDoNowychLini"/>
		<xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini"/>
		<xsl:choose>
			<xsl:when test="contains($tekstPoOstatnimPrzejsciuDoNowejLini,'&#xA;')">
				<xsl:variable name="liczbaLini">
					<!-- chodzi o makstylana dlugosc - przypadek kiedy caly tekst skladal sie z liter 'W' -->
					<xsl:value-of select="ceiling((string-length(substring-before($tekstPoOstatnimPrzejsciuDoNowejLini,'&#xA;')) * $bazowyRozmiarCzcionki) div $szerokosc)"/>
				</xsl:variable>
				<xsl:call-template name="formatTextArea">
					<xsl:with-param name="tekst" select="$tekst"/>
					<xsl:with-param name="wysokosc" select="$wysokosc"/>
					<xsl:with-param name="szerokosc" select="$szerokosc"/>
					<xsl:with-param name="bazowyRozmiarCzcionki" select="$bazowyRozmiarCzcionki"/>
					<xsl:with-param name="wysokoscLini" select="$wysokoscLini"/>
					<xsl:with-param name="liczbaPrzejscDoNowychLini" select="$liczbaPrzejscDoNowychLini + $liczbaLini"/>
					<xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini">
						<xsl:value-of select="substring-after($tekstPoOstatnimPrzejsciuDoNowejLini,'&#xA;')"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="liczbaLini">
					<xsl:value-of select="ceiling(string-length($tekstPoOstatnimPrzejsciuDoNowejLini) * $bazowyRozmiarCzcionki div $szerokosc)"/>
				</xsl:variable>
				<xsl:call-template name="redukcjaCzcionkiTextArea">
					<xsl:with-param name="tekst" select="$tekst"/>
					<xsl:with-param name="wysokosc" select="$wysokosc"/>
					<xsl:with-param name="szerokosc" select="$szerokosc"/>
					<xsl:with-param name="bazowyRozmiarCzcionki" select="$bazowyRozmiarCzcionki"/>
					<xsl:with-param name="wysokoscLini" select="$wysokoscLini"/>
					<xsl:with-param name="liczbaPrzejscDoNowychLini" select="$liczbaPrzejscDoNowychLini + $liczbaLini"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="redukcjaCzcionkiTextArea">
		<xsl:param name="tekst"/>
		<xsl:param name="wysokosc"/>
		<xsl:param name="szerokosc"/>
		<xsl:param name="bazowyRozmiarCzcionki"/>
		<xsl:param name="wysokoscLini"/>
		<xsl:param name="liczbaPrzejscDoNowychLini"/>
		<xsl:variable name="liczbaLini">
			<xsl:value-of select="$liczbaPrzejscDoNowychLini"/>			
		</xsl:variable>
		<xsl:variable name="liczbaLiniKtoraSieMiesci">
			<xsl:value-of select="$wysokosc div $wysokoscLini"/>
		</xsl:variable>
		<xsl:variable name="roznicaLiczyLini">
			<xsl:value-of select="ceiling($liczbaLini) - floor($liczbaLiniKtoraSieMiesci)"/>
		</xsl:variable>
		<xsl:variable name="ulamekOJakiZmniejszamy">
			<xsl:choose>
				<xsl:when test="$roznicaLiczyLini &lt; 1">1</xsl:when>
				<xsl:otherwise>
					<!-- Obliczenie bez zaokrągląnia liczbaLiniKtoraSieMiesci
					 Założono, że współczynnik zmiany dla szerokość, długość jest jednakowy, stąd pierwiastek -->
					<xsl:variable name="ulamekOJakiZmniejszamyBezZaokraglenLinii">
						<xsl:call-template name="sqrt">
						   <xsl:with-param name="number" select="$liczbaLiniKtoraSieMiesci div $liczbaLini"/>
						</xsl:call-template>
					</xsl:variable>
					<!-- Wymagane zaokrąglenia w górę, liczby linii -->
					<xsl:variable name="CalkowitaLiczbaLinii">
						<xsl:value-of select="ceiling($liczbaLiniKtoraSieMiesci div $ulamekOJakiZmniejszamyBezZaokraglenLinii)"/>
					</xsl:variable>
					<!-- Ponowne przeliczenie ułamka po wyznaczeniu całkowitej liczby linii -->			
					<xsl:value-of select="$liczbaLiniKtoraSieMiesci div $CalkowitaLiczbaLinii"/>						
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="docelowyRozmiarCzcionki">
			<xsl:value-of select="$ulamekOJakiZmniejszamy"></xsl:value-of>
		</xsl:variable>
		<xsl:variable name="docelowaWysokoscLini">
			<xsl:value-of select="floor($wysokoscLini * $ulamekOJakiZmniejszamy)"/>			
		</xsl:variable>
		<div>
			<xsl:attribute name="style"><xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'em;', 'line-height:', $docelowaWysokoscLini, 'px; word-wrap : break-word;')"/></xsl:attribute>
			<xsl:call-template name="podzialTekstuWTextArea">
				<xsl:with-param name="tekst" select="$tekst"/>
				<xsl:with-param name="docelowyRozmiarCzcionki" select="$docelowyRozmiarCzcionki"/>
				<xsl:with-param name="docelowaWysokoscLini" select="$docelowaWysokoscLini"/>
			</xsl:call-template>
		</div>
	</xsl:template>
	<xsl:template name="podzialTekstuWTextArea">
		<xsl:param name="tekst"/>
		<xsl:param name="docelowyRozmiarCzcionki"/>
		<xsl:param name="docelowaWysokoscLini"/>
		<xsl:choose>
			<xsl:when test="contains($tekst,'&#xA;')">
				<div>
					<xsl:value-of select="substring-before($tekst,'&#xA;')"/>
				</div>
				<xsl:call-template name="podzialTekstuWTextArea">
					<xsl:with-param name="tekst" select="substring-after($tekst,'&#xA;')"/>
					<xsl:with-param name="docelowyRozmiarCzcionki" select="$docelowyRozmiarCzcionki"/>
					<xsl:with-param name="docelowaWysokoscLini" select="$docelowaWysokoscLini"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<div>
					<xsl:value-of select="$tekst"/>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Szablon służący do obliczenia pierwiastka kwadratowego z liczby -->
	<xsl:template name="sqrt">
	<!--  The number you want to find the square root of  -->
	   <xsl:param name="number"
				  select="0" />
	<!--  The current 'try'.  This is used internally.  -->
	   <xsl:param name="try"
				  select="1" />
	<!--  The current iteration, checked against maxiter to limit loop count  -->
	   <xsl:param name="iter"
				  select="1" />
	<!--  Set this up to ensure against infinite loops  -->
	   <xsl:param name="maxiter"
				  select="10" />
	<!--  This template was written by Nate Austin using Sir Isaac Newton's
		   method of finding roots  -->
	   <xsl:choose>
		  <xsl:when test="$try * $try = $number or $iter > $maxiter">
			 <xsl:value-of select="$try" />
		  </xsl:when>
		  <xsl:otherwise>
			 <xsl:call-template name="sqrt">
				<xsl:with-param name="number"
								select="$number" />
				<xsl:with-param name="try"
								select="$try - (($try * $try - $number) div (2 * $try))" />
				<xsl:with-param name="iter"
								select="$iter + 1" />
				<xsl:with-param name="maxiter"
								select="$maxiter" />
			 </xsl:call-template>
		  </xsl:otherwise>
	   </xsl:choose>
	</xsl:template>	
	
</xsl:stylesheet>
